/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.help;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.help.HscHelpFontTree;
import com.ibm.hsc.common.help.HscHelpSecurityManager;
import com.ibm.websm.bridge.WSessionMgr;
import com.ibm.websm.console.WWorkingDialog;
import com.ibm.websm.diagnostics.Diag;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EWorkingListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.Vector;
import javax.help.DefaultHelpModel;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelp;
import javax.help.JHelpContentViewer;
import javax.help.Map;
import javax.help.TextHelpModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class LoadHscHelp {
    private static JFrame frame;
    private static Font[] fonts;
    private JFrame elementTreeFrame;
    private JHelp jh;
    private HelpSet hs;
    private Map.ID _id;
    private static EWorkingListener listener;
    private static WWorkingDialog wd;
    private URL _url;
    static /* synthetic */ Class class$com$ibm$websm$etc$EWorkingListener;

    public Frame getFrame() {
        return frame;
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Font");
        jMenu.setFont(new Font("SansSerif", 0, 12));
        JMenu jMenu2 = jMenuBar.add(jMenu);
        jMenu2.setMnemonic('F');
        JMenuItem jMenuItem = new JMenuItem("Set Font");
        jMenuItem.setFont(new Font("SansSerif", 0, 12));
        jMenuItem.setMnemonic('S');
        jMenuItem.setToolTipText("Click on to change the Font...");
        JMenuItem jMenuItem2 = jMenu2.add(jMenuItem);
        SetFontListener setFontListener = new SetFontListener();
        jMenuItem2.addActionListener(setFontListener);
        return jMenuBar;
    }

    public LoadHscHelp(String string, String string2) {
        try {
            this._url = string2.trim().substring(0, 4).equalsIgnoreCase("http") ? new URL(string2) : new File(string2).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            Diag.programError((String)("Could not load the Help Set " + string2));
            System.exit(1);
        }
        try {
            this.hs = new HelpSet(this.getClass().getClassLoader(), this._url);
            this.jh = new JHelp(this.hs);
            this.jh.setFont(new Font("Devanagari MT for IBM", 0, 13));
            this.jh.putClientProperty((Object)"JTree.lineStyle", (Object)"Angled");
            DefaultHelpModel defaultHelpModel = new DefaultHelpModel(this.hs);
            this.jh.setModel((TextHelpModel)defaultHelpModel);
            if (!string.trim().equals("0") & !string.trim().equals("1") & !string.trim().equals("2")) {
                this.jh.setCurrentID(string);
                this.jh.setNavigatorDisplayed(false);
                this.hs.setTitle("Hardware System Console - Help");
            }
            String string3 = "";
            if (string.trim().equals("0") || string.trim().equals("1") || string.trim().equals("2")) {
                if (string.trim().equals("0")) {
                    String string4 = this.hs.toString().trim();
                    System.out.println(string4);
                    if (string4.equals("Hardware System Console - Help on User Management")) {
                        string3 = "host.users";
                    }
                    if (string4.equals("Hardware System Console - Help on Partition Management")) {
                        string3 = "host.lpar";
                    }
                    if (string4.equals("Hardware System Console - Help on Service Focal Point")) {
                        string3 = "host.sfp";
                    }
                    if (string4.equals("Hardware System Console - Help on Service Agent")) {
                        string3 = "host.sa";
                    }
                    if (string4.equals("Hardware System Console - Help on Problem Determination")) {
                        string3 = "host.probdeter";
                    }
                    if (string4.equals("Hardware System Console - Help on Software Maintenance")) {
                        string3 = "host.softmaint";
                    }
                    if (string4.equals("Hardware System Console - Help on System Configuration")) {
                        string3 = "host.sysconfig";
                    }
                    if (IDebug.enabled) {
                        IDebug.println((String)("ID : " + string3));
                    }
                    this.setID(string3);
                }
                if (string.trim().equals("1")) {
                    this.hs.setTitle("Hardware System Console - Help Search");
                }
                if (string.trim().equals("2")) {
                    this.hs.setTitle("Hardware System Console - Help On Help");
                }
            }
            this.createFrame(this.createMenuBar());
            this.launch();
            if (!(string.trim().equals("0") || string.trim().equals("1") || string.trim().equals("2"))) {
                this.jh.setNavigatorDisplayed(false);
                this.hs.setTitle("Hardware System Console - Help");
            }
            if (!string.trim().equals("1") || !string.trim().equals("2")) {
                this.setID(string3);
            }
            if (listener != null) {
                listener.eof(0);
                listener.showDialog(false);
            }
        }
        catch (HelpSetException helpSetException) {
            System.err.println("Could not create HelpSet for " + string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private JTextComponent getEditor() {
        JHelpContentViewer jHelpContentViewer = this.jh.getContentViewer();
        JScrollPane jScrollPane = (JScrollPane)jHelpContentViewer.getComponent(0);
        JViewport jViewport = jScrollPane.getViewport();
        return (JTextComponent)jViewport.getView();
    }

    public static void main(String[] stringArray) {
        wd = new WWorkingDialog((Frame)new JFrame("Launching HSC Help..."), HSCResourceBundleUtil.getMessage("UserBundle", "WORKING", "Working"));
        listener = (EWorkingListener)WSessionMgr.getProxy((String)(class$com$ibm$websm$etc$EWorkingListener == null ? (class$com$ibm$websm$etc$EWorkingListener = LoadHscHelp.class$("com.ibm.websm.etc.EWorkingListener")) : class$com$ibm$websm$etc$EWorkingListener).getName(), (Object)wd);
        if (listener != null) {
            listener.showDialog(true);
        }
        try {
            Class<?> clazz = Class.forName("javax.swing.JComponent");
            if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
                System.setSecurityManager(new HscHelpSecurityManager());
            }
            new LoadHscHelp(stringArray[0].trim(), stringArray[1].trim());
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            if (listener != null) {
                listener.eof(0);
                listener.showDialog(false);
            }
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (listener != null) {
                listener.eof(0);
                listener.showDialog(false);
            }
            System.exit(1);
        }
    }

    protected JFrame createFrame(JMenuBar jMenuBar) {
        frame = new JFrame(this.hs.getTitle());
        frame.setSize(550, 450);
        frame.setForeground(Color.black);
        frame.setBackground(Color.lightGray);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }

            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }
        };
        frame.addWindowListener(windowAdapter);
        frame.getContentPane().add((Component)this.jh);
        frame.setFont(new Font("Devanagari MT for IBM", 0, 13));
        jMenuBar = this.createMenuBar();
        frame.setJMenuBar(jMenuBar);
        frame.setSize(550, 450);
        frame.setLocation(new Point(450, 260));
        return frame;
    }

    protected void launch() {
        frame.setVisible(true);
        frame.setSize(550, 450);
        frame.setLocation(new Point(450, 260));
        this.jh.repaint();
        frame.repaint();
    }

    private void setID(String string) {
        block3: {
            if (string.trim().length() <= 0) break block3;
            if (IDebug.enabled) {
                IDebug.println((String)"creating a Map ID...");
            }
            try {
                this._id = Map.ID.create((String)string, (HelpSet)this.hs);
                this.jh.setCurrentID(this._id);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ShowElementTreeListener
    implements ActionListener {
        ShowElementTreeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LoadHscHelp.this.elementTreeFrame = null;
            if (LoadHscHelp.this.elementTreeFrame == null) {
                Object object;
                try {
                    object = "Element Tree For Current Document";
                    LoadHscHelp.this.elementTreeFrame = new JFrame((String)object);
                }
                catch (MissingResourceException missingResourceException) {
                    LoadHscHelp.this.elementTreeFrame = new JFrame();
                }
                LoadHscHelp.this.elementTreeFrame.addWindowListener(new WindowAdapter(this){
                    private final /* synthetic */ ShowElementTreeListener this$1;
                    {
                        this.this$1 = showElementTreeListener;
                    }

                    public void windowClosing(WindowEvent windowEvent) {
                        LoadHscHelp.access$200(ShowElementTreeListener.access$300(this.this$1)).setVisible(false);
                    }
                });
                object = LoadHscHelp.this.elementTreeFrame.getContentPane();
                ((Container)object).setLayout(new BorderLayout());
                ((Container)object).add(new HscHelpFontTree(LoadHscHelp.this.getEditor()));
                LoadHscHelp.this.elementTreeFrame.pack();
            }
            LoadHscHelp.this.elementTreeFrame.show();
        }

        static /* synthetic */ LoadHscHelp access$300(ShowElementTreeListener showElementTreeListener) {
            return showElementTreeListener.LoadHscHelp.this;
        }
    }

    private class HscFont {
        private Font f;

        public HscFont(Font font) {
            this.f = font;
        }

        public Font getFont() {
            return this.f;
        }

        public String toString() {
            String string = this.f.getFamily();
            String string2 = this.f.getFontName();
            String string3 = string2.substring(string.length());
            if (string3.length() == 0) {
                string3 = "Plain";
            }
            return string3;
        }
    }

    private class SetFontListener
    implements ActionListener,
    TreeSelectionListener,
    ItemListener {
        JDialog sfDialog = null;
        JComboBox cb;
        JTree fontTree;
        JTextArea preview;
        JButton okButton;
        JButton cancelButton;
        Font font;

        private SetFontListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                JOptionPane.showMessageDialog(null, "Setting Fonts on JDK1.1 not allowed", "Set Font...", 0);
                return;
            }
            if (this.sfDialog == null) {
                this.sfDialog = new JDialog(LoadHscHelp.this.getFrame(), "Set Font...", false);
                this.initSetFontComponents();
                this.sfDialog.pack();
                this.cancelButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        sfDialog.setVisible(false);
                        sfDialog.dispose();
                    }
                });
                this.okButton.addActionListener(new ActionListener(this){
                    private final /* synthetic */ SetFontListener this$1;
                    {
                        this.this$1 = setFontListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        LoadHscHelp.access$100(SetFontListener.access$000(this.this$1)).setFont(this.this$1.font);
                        this.this$1.sfDialog.setVisible(false);
                        this.this$1.sfDialog.dispose();
                    }
                });
            }
            this.font = LoadHscHelp.this.jh.getFont();
            this.preview.setFont(this.font);
            this.sfDialog.show();
        }

        private void initSetFontComponents() {
            Serializable serializable;
            Object object;
            Serializable serializable2;
            Object object2;
            Object object3;
            Serializable serializable3;
            Vector vector = new Vector();
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Font[] fontArray = graphicsEnvironment.getAllFonts();
            int n = 0;
            while (n < fontArray.length) {
                serializable3 = new DefaultMutableTreeNode(new HscFont(fontArray[n]));
                object3 = fontArray[n].getFamily();
                object2 = null;
                serializable2 = null;
                object = defaultMutableTreeNode.children();
                while (object.hasMoreElements()) {
                    serializable2 = (DefaultMutableTreeNode)object.nextElement();
                    object2 = (String)((DefaultMutableTreeNode)serializable2).getUserObject();
                    if (((String)object2).compareTo((String)object3) == 0) break;
                    serializable2 = null;
                }
                if (serializable2 == null) {
                    serializable = new DefaultMutableTreeNode(object3);
                    defaultMutableTreeNode.add((MutableTreeNode)((Object)serializable));
                    ((DefaultMutableTreeNode)serializable).add((MutableTreeNode)((Object)serializable3));
                } else {
                    ((DefaultMutableTreeNode)serializable2).add((MutableTreeNode)((Object)serializable3));
                }
                ++n;
            }
            serializable3 = Box.createVerticalBox();
            object3 = Box.createHorizontalBox();
            this.fontTree = new JTree(defaultMutableTreeNode);
            this.fontTree.setShowsRootHandles(true);
            this.fontTree.setRootVisible(true);
            this.fontTree.putClientProperty("JTree.lineStyle", "Angled");
            this.fontTree.setExpandsSelectedPaths(true);
            object2 = this.fontTree.getSelectionModel();
            object2.addTreeSelectionListener(this);
            serializable2 = new JScrollPane();
            ((JScrollPane)serializable2).getViewport().add(this.fontTree);
            TitledBorder titledBorder = BorderFactory.createTitledBorder("Fonts");
            ((JComponent)serializable2).setBorder(titledBorder);
            ((Container)object3).add(Box.createHorizontalStrut(4));
            ((Container)object3).add((Component)serializable2);
            ((Container)object3).add(Box.createHorizontalStrut(4));
            object = Box.createHorizontalBox();
            this.cb = new JComboBox();
            titledBorder = BorderFactory.createTitledBorder("Size");
            this.cb.setBorder(titledBorder);
            this.cb.setEditable(true);
            this.cb.addItem("8");
            this.cb.addItem("9");
            this.cb.addItem("10");
            this.cb.addItem("11");
            this.cb.addItem("12");
            this.cb.addItem("13");
            this.cb.addItem("14");
            this.cb.addItem("16");
            this.cb.setSelectedItem("12");
            this.cb.addItemListener(this);
            ((Container)object).add(Box.createHorizontalStrut(3));
            ((Container)object).add(this.cb);
            ((Container)object).add(Box.createHorizontalStrut(3));
            ((Container)object3).add((Component)object);
            ((Container)object3).add(Box.createHorizontalStrut(3));
            ((Container)serializable3).add(Box.createVerticalStrut(7));
            ((Container)serializable3).add(Box.createVerticalStrut(4));
            ((Container)serializable3).add((Component)object3);
            serializable = Box.createHorizontalBox();
            JPanel jPanel = new JPanel();
            titledBorder = BorderFactory.createTitledBorder("Preview");
            jPanel.setBorder(titledBorder);
            this.preview = new JTextArea("\nAaBbCc...XxYyZz\n");
            jPanel.add(this.preview);
            ((Container)serializable).add(Box.createHorizontalStrut(5));
            ((Container)serializable).add(jPanel);
            ((Container)serializable).add(Box.createHorizontalStrut(5));
            ((Container)serializable3).add(Box.createVerticalStrut(7));
            ((Container)serializable3).add((Component)serializable);
            Box box = Box.createHorizontalBox();
            this.okButton = new JButton("OK");
            this.cancelButton = new JButton("Cancel");
            box.add(this.okButton);
            box.add(this.cancelButton);
            Box box2 = Box.createHorizontalBox();
            box2.add(Box.createHorizontalStrut(5));
            box2.add(new JSeparator());
            box2.add(Box.createHorizontalStrut(5));
            ((Container)serializable3).add(Box.createVerticalStrut(10));
            ((Container)serializable3).add(box2);
            ((Container)serializable3).add(box);
            this.sfDialog.getContentPane().add((Component)serializable3);
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = this.fontTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof HscFont) {
                HscFont hscFont = (HscFont)object;
                String string = (String)this.cb.getSelectedItem();
                this.font = hscFont.getFont().deriveFont(Integer.valueOf(string).floatValue());
                this.preview.setFont(this.font);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            String string = (String)this.cb.getSelectedItem();
            this.font = this.font.deriveFont(Integer.valueOf(string).floatValue());
            this.preview.setFont(this.font);
        }

        static /* synthetic */ LoadHscHelp access$000(SetFontListener setFontListener) {
            return setFontListener.LoadHscHelp.this;
        }
    }
}

